/*
PARA LA ANIMACIN DE SALTO DE UNA SECCIN A OTRA.
El enlace debe ser del tipo href="#ancla" y tener la clase "jquery-pag":

	<a href="#inicio" class="jquery-pag">Inicio</a>

Y el destino debe tener id="ancla":

	<section id="inicio">

La altura de la seccin de establece como mnimo a la altura de la ventana.
*/

var secciones = new Array(
	//Secciones a altura completa: poner una por lnea entre comillas y con una coma para separar
	"#presentacion",
	"#servicios",
	"#proyectos",
	"#contacto"
);

$(function(){

	$('a[href*="#"].jquery-pag').click(function() {
	
		if (location.pathname.replace(/^\//,'') == this.pathname.replace(/^\//,'')
		&& location.hostname == this.hostname) {
		
			var $target = $(this.hash);
			
			$target = $target.length && $target || $('[name=' + this.hash.slice(1) +']');
			
			if ($target.length) {
			
				var targetOffset = $target.offset().top;
				
				$('html,body').animate({scrollTop: targetOffset}, 1000);
				
				return false;
		
			}
		
		}
	
	});
	

	$.each(secciones, function( index, value ) {
		$(value).css({'min-height':($(window).height())+'px'});
	});
	$(window).resize(function(){
		$.each(secciones, function( index, value ) {
			$(value).css({'min-height':($(window).height())+'px'});
		});
	});	
});

